;/*******************************************************************************
;* File:    MC56F8006_init.asm
;*
;* Purpose: Provide initialization routine for the MC56F8006 device.
;*
;********************************************************************************
;* Notes:
;*   
;*******************************************************************************/

 include "MC56F8006.inc"
 include "MC56F8006_init.inc"
 
	section startup
	
	XREF	F_stack_addr
	
	org p:
	
	GLOBAL Finit_MC56F8006_
	
	SUBROUTINE "Finit_MC56F8006_",Finit_MC56F8006_,Finit_MC56F8006_END-Finit_MC56F8006_
Finit_MC56F8006_:

    ;; Initialize Vector Base Address, Stack Pointer, and OMR
    moveu.w #>F_Lstack_addr,r0      ; Import SP address from linker
    tfra    r0,sp                   ; Set SP
    bfset   #OMR_SD,OMR             ; Set OMR
;   move.w  #0,x:(INTC_VBA)         ; Default VBA is 0x0

    ;; Set TRIM bits using Flash Config Data
    move.l   #FM_OPT0,R0            ; set R0 as pointer to factory-flashed trim value
    move.l   #PMC_CR2,R1            ; set R1 as pointer to PMC_CR2
    move.w   X:(R0),A               ; set A as factory-flashed trim value
    move.w   A1,X:(R1)              ; set PMC_CR2
         
    ;; Select prescaler clock (ZSRC=1), power down PLL, enable lock detector
    bfclr   #OCCS_CTRL_ZSRC,x:>OCCS_CTRL
    bfset   #(OCCS_CTRL_ZSRC_0|OCCS_CTRL_PLLPD|OCCS_CTRL_LCKON),x:>OCCS_CTRL
	
    ;; Power on PLL, wait for lock (LCK0=1), select postscaler clock (ZSRC=2)
    bfclr   #OCCS_CTRL_PLLPD,x:>OCCS_CTRL
	
    ;; Loop until OCCS_STAT[LCK0] = 1
wait_for_lock: 
    brclr   #OCCS_STAT_LCK0,x:>OCCS_STAT,wait_for_lock
	
    ;; Set ZSRC bits
    bfclr   #OCCS_CTRL_ZSRC,x:>OCCS_CTRL
    bfset   #OCCS_CTRL_ZSRC_1,x:>OCCS_CTRL

    ;; Utilities
    jsr     F__zeroBSS              ; fill BSS space with zeroes
    jsr     F__romCopy              ; do any rom-to-ram copy
                                    ; LCF sets rom-to-ram flag

    ; Call main()
    move.w  #0,y0                   ; pass parameters to main()
    move.w  #0,R2
    move.w  #0,R3
    jsr     Fmain                   ; call the users program
exit_loop:
    bra     exit_loop               ; end of program
                                    
;   jsr     Fexit_halt              ; hostIO cleanup with exit_halt
                                    ; stationery examples use standard i/o 
                                    ; such as printf implemented with hostIO 
                                    ; so we use exit_halt here 
                                    ; see runtime file exit_dsp.asm
                                    ; comment out exit_halt if not using hostIO                                                                         
    debughlt                        ; or simple end of program (halt CPU)
Finit_MC56F8006_END:

    endsec

